/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.google.common.collect.Maps;
import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.config.IllagerAdditionsConfig;
import com.pikachu.mod.illager_more.entities.NewCowboyEntity;
import com.pikachu.mod.illager_more.entities.SamuraiEntity;
import com.pikachu.mod.illager_more.entities.ai.AvoidAndApproachTargetGoal;
import com.pikachu.mod.illager_more.entities.effects.AttackEffects;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class NewSamuraiEntity
extends AbstractIllager
implements IAnimatable {
    public static final UUID SPEED_MODIFIER_RUNNING_UUID = UUID.fromString("05cd373b-0ff1-4ded-8630-b380232ed7b1");
    public static final AttributeModifier SPEED_MODIFIER_RUN = new AttributeModifier(SPEED_MODIFIER_RUNNING_UUID, "Running speed increase", 0.1, AttributeModifier.Operation.ADDITION);
    protected static final UUID MODIFIER_UUID = UUID.fromString("054d370b-0ff1-4ded-8630-b380232ed7b1");
    protected static final AttributeModifier MODIFIER = new AttributeModifier(MODIFIER_UUID, "increase", 1.0, AttributeModifier.Operation.ADDITION);
    public static final EntityDataAccessor<Boolean> IS_PULLED_OUT_WEAPON = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PULLING_OUT_WEAPON = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_WITHDRAW_WEAPON = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CAN_MELEE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CAN_JUMP_MELEE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_MELEE_FAST = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DESTROY_PROJECTILES = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DODGE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CAN_DODGE_ROLL = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DODGE_ROLL = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_PARRY = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_JUMP = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_JUMP_ATTACK = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_DASH = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_RUN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> PARRY_TICK = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_TICK = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_TICK = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BLOCK_TICK = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PARRY_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DODGE_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MELEE_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DESTROY_PROJECTILES_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DASH_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> JUMP_COOLDOWN = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MELEE_TYPE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DESTROY_PROJECTILES_TYPE = SynchedEntityData.m_135353_(NewSamuraiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int timer = 0;
    protected int noDamagesTimer = 0;
    protected int parryTimes = 0;
    protected int maxParryTimes = 3;
    protected int maxParryChanges = 4;
    protected int haveNotParryTimes;
    protected int MemoryTimeAfterTargetDisappears;
    protected List<Projectile> reboundedProjectiles;
    public int aiStrength;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    protected boolean isRed;

    public void setRed(boolean red) {
        this.isRed = red;
    }

    public boolean isRed() {
        return this.isRed;
    }

    public NewSamuraiEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 15;
        this.haveNotParryTimes = 0;
        this.MemoryTimeAfterTargetDisappears = 0;
        this.reboundedProjectiles = new ArrayList<Projectile>();
        this.aiStrength = (Integer)IllagerAdditionsConfig.samurai_ai_strength.get();
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        if (this.m_6095_() == ModEntityTypes.SAMURAI.get()) {
            for (int i = 3 - this.aiStrength; i < 4; ++i) {
                this.m_19983_(new ItemStack((ItemLike)Items.f_42616_));
            }
        }
        super.m_7472_(p_21385_, p_21386_, p_21387_);
    }

    public boolean m_20147_() {
        return super.m_20147_();
    }

    public List<Projectile> getReboundedProjectiles() {
        return this.reboundedProjectiles;
    }

    public int getTimer() {
        return this.timer;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        p_37870_.m_128405_("AIStrength", this.aiStrength);
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.aiStrength = p_37862_.m_128451_("AIStrength");
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.populateDefaultEquipmentSlots(p_37857_);
        this.m_213946_(this.f_19796_, p_37857_);
        this.reboundedProjectiles.addAll(this.f_19853_.m_45976_(Projectile.class, this.m_20191_().m_82400_(64.0)));
        if (p_37858_ == MobSpawnType.STRUCTURE) {
            this.aiStrength = this.f_19796_.m_188503_(2) + 1 + (this.f_19796_.m_188500_() <= (double)0.175f ? 1 : 0);
        }
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void populateDefaultEquipmentSlots(@Nonnull DifficultyInstance p_180481_1_) {
        if (this.m_37885_() == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
        }
        if (this.m_37885_() == null) {
            if (this.m_217043_().m_188503_(88 - 28 * p_180481_1_.m_19048_().m_19028_()) == 0) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.SAMURAI_HELMET.get()));
                this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_CHESTPLATE.get()));
                this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_LEGGINGS.get()));
                this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_BOOTS.get()));
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.53846153846);
                this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.53846153846);
                this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
                if (this.m_37885_() == null) {
                    this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
                }
            } else {
                this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_ROBES.get()));
                this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_PANTS.get()));
                this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_SHOES.get()));
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.registerAttackGoal();
    }

    protected void registerAttackGoal() {
        this.f_21345_.m_25352_(0, (Goal)new DoHurtTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new JumpDoHurtTargetGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DestroyProjectileGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new PullOutWeaponGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new JumpGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new WithdrawWeaponGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DodgeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DodgeRollGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DashGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SamuraiAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 6.5f, 1.2, 0.65, true));
        this.f_21345_.m_25352_(5, (Goal)new SamuraiAttackGoal(this, 1.2, true));
    }

    public void m_8107_() {
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            if (!(((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_JUMP_ATTACK)).booleanValue())) {
                this.m_20256_(Vec3.f_82478_);
            }
            this.m_21573_().m_26573_();
            this.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
        }
        if (this.f_19797_ % 60 == 0 && !((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            this.f_19804_.m_135381_(DESTROY_PROJECTILES_TYPE, (Object)0);
        }
        this.setRed(EnchantmentHelper.m_44914_((LivingEntity)this) > 0);
        LivingEntity entity = this.m_5448_();
        if (entity != null) {
            this.MemoryTimeAfterTargetDisappears = this.f_19797_ + 90;
        }
        for (NewSamuraiEntity samurai : this.f_19853_.m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82400_(20.0))) {
            if (entity == null || !samurai.m_21574_().m_148306_((Entity)entity) || !samurai.m_7307_((Entity)this) || samurai == this || samurai.m_5448_() != null && (samurai.m_5448_() == null || samurai.m_5448_().m_6084_())) continue;
            samurai.m_6710_(entity);
        }
        if (--this.haveNotParryTimes <= 0) {
            this.parryTimes = Math.max(this.parryTimes / 2 - 1, 0);
        }
        super.m_8107_();
        this.CooldownReduction();
        this.TickReduction();
    }

    public boolean m_6469_(DamageSource type, float damages) {
        this.f_19804_.m_135381_(PARRY_TICK, (Object)0);
        boolean b = false;
        if (type.m_19360_() && ((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            Projectile projectile = (Projectile)type.m_7640_();
            for (Entity entityHit : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(4.0, 4.0, 4.0))) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= 4.0f && (double)entityRelativeAngle <= 65.0 && (double)entityRelativeAngle >= -65.0 || (double)entityRelativeAngle >= 295.0) && !((double)entityRelativeAngle <= -295.0) || type.m_7640_() != entityHit) continue;
                b = true;
                break;
            }
            if (((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
                return false;
            }
        }
        if (!(type.m_19376_() || type.m_19360_() && !(type.m_7639_() instanceof NewCowboyEntity) || type.m_19372_())) {
            if (!type.m_19376_()) {
                if (!this.m_20096_() && ((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
                    return false;
                }
                if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
                    return false;
                }
                if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) {
                    return false;
                }
                if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0 && !((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue()) {
                    return false;
                }
                if (type.m_7639_() != null) {
                    b = this.m_21574_().m_148306_(type.m_7639_());
                }
                for (Entity entityHit : this.f_19853_.m_45976_(Entity.class, this.m_20191_().m_82377_(4.0, 4.0, 4.0))) {
                    float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                    float entityAttackingAngle = this.f_20883_ % 360.0f;
                    if (entityHitAngle < 0.0f) {
                        entityHitAngle += 360.0f;
                    }
                    if (entityAttackingAngle < 0.0f) {
                        entityAttackingAngle += 360.0f;
                    }
                    float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                    float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                    if (!(entityHitDistance <= 4.0f && (double)entityRelativeAngle <= 65.0 && (double)entityRelativeAngle >= -65.0 || (double)entityRelativeAngle >= 295.0) && !((double)entityRelativeAngle <= -295.0) || type.m_7640_() != entityHit) continue;
                    b = true;
                    break;
                }
                if ((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) <= 0 && ((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue() && !(type.m_7639_() instanceof Player) && this.parryTimes <= this.maxParryTimes) {
                    if (this.m_217043_().m_188500_() > 0.6 && this.maxParryTimes > 6) {
                        this.haveNotParryTimes = 100;
                        ++this.parryTimes;
                        this.f_19804_.m_135381_(PARRY_TICK, (Object)15);
                        if (this.parryTimes > 4) {
                            this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)18);
                        }
                        this.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
                        if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && type.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)type.m_7639_())) {
                            this.m_6710_((LivingEntity)type.m_7639_());
                        }
                        return false;
                    }
                    return super.m_6469_(type, damages);
                }
                if (this.m_217043_().m_188503_(Math.max((4 - this.aiStrength) * (4 - this.aiStrength), this.maxParryChanges)) == 0 && (Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) <= 0 && b && this.parryTimes <= this.maxParryTimes && !((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
                    this.haveNotParryTimes = 100;
                    this.f_19804_.m_135381_(PARRY_TICK, (Object)15);
                    if ((double)this.parryTimes >= (double)this.maxParryTimes / 1.87666) {
                        this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)18);
                    }
                    ++this.parryTimes;
                    this.m_21573_().m_26573_();
                    this.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
                    if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && type.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)type.m_7639_())) {
                        this.m_6710_((LivingEntity)type.m_7639_());
                    }
                    return damages >= (float)((10 + this.m_217043_().m_188503_(10)) * this.aiStrength) ? super.m_6469_(type, damages * 0.05f) : false;
                }
            }
            if (this.noDamagesTimer > 0 && !(type.m_7640_() instanceof Player) && type.m_7640_() != this.m_21188_() && this.m_217043_().m_188499_()) {
                if ((this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_()) && type.m_7639_() instanceof LivingEntity && this.m_6779_((LivingEntity)type.m_7639_())) {
                    this.m_6710_((LivingEntity)type.m_7639_());
                }
                return false;
            }
        }
        return super.m_6469_(type, damages);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
        Map<Enchantment, Integer> enchantmentIntegerMap;
        boolean applyEnchant;
        boolean b = true;
        ItemStack katana = new ItemStack((ItemLike)ModItems.KATANA.get());
        if (this.m_217043_().m_188503_(88 - 28 * this.f_19853_.m_46791_().m_19028_()) == 0) {
            b = false;
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.SAMURAI_HELMET.get()));
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_CHESTPLATE.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_LEGGINGS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_BOOTS.get()));
            this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.53846153846);
            this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.53846153846);
            this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
            if (this.m_37885_() == null) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.KATANA.get()));
            }
        }
        Raid raid = this.m_37885_();
        int enchantmentLevel = 2;
        if (raid != null && p_213660_1_ > raid.m_37724_(Difficulty.NORMAL)) {
            enchantmentLevel = 3;
        }
        if (raid == null) {
            this.m_8061_(EquipmentSlot.MAINHAND, katana);
            return;
        }
        boolean bl = applyEnchant = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (applyEnchant) {
            enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.f_44977_, enchantmentLevel);
            EnchantmentHelper.m_44865_((Map)enchantmentIntegerMap, (ItemStack)katana);
        }
        boolean bl2 = applyEnchant = this.f_19796_.m_188501_() <= raid.m_37783_() / 2.0f;
        if (applyEnchant && ((Boolean)IllagerAdditionsConfig.special_samurai_raid_spawning.get()).booleanValue()) {
            this.aiStrength = 2;
            if ((double)this.f_19796_.m_188501_() <= 0.35 && b) {
                this.aiStrength = 3;
                enchantmentIntegerMap = katana.getAllEnchantments();
                enchantmentIntegerMap.put(Enchantments.f_44981_, 2);
                EnchantmentHelper.m_44865_(enchantmentIntegerMap, (ItemStack)katana);
                this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.R_SAMURAI_ROBES.get()));
                this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.R_SAMURAI_PANTS.get()));
                this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.R_SAMURAI_SHOES.get()));
                b = false;
            }
            if (this.m_21233_() < 30.0f) {
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.53846153846);
                this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.53846153846);
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) * 1.25);
                this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) * 1.25);
            }
            this.m_21153_((float)this.m_21133_(Attributes.f_22276_));
        }
        if (b) {
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.SAMURAI_ROBES.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.SAMURAI_PANTS.get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.SAMURAI_SHOES.get()));
        }
        float f = Math.min((this.f_19853_.m_6436_(this.m_20183_()).m_19057_() + this.m_37885_().m_37783_()) / 1.5f, 1.0f);
        this.m_214095_(this.m_217043_(), f);
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            this.m_217051_(this.m_217043_(), f, equipmentslot);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, katana);
    }

    public static void DestroyProjectiles(@Nonnull NewSamuraiEntity samuraiEntity, float range, float X, float Y, float Z, float arc) {
        boolean b = false;
        for (Projectile projectile : samuraiEntity.f_19853_.m_45976_(Projectile.class, samuraiEntity.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            Projectile newProjectile;
            float entityHitAngle = (float)((Math.atan2(projectile.m_20189_() - samuraiEntity.m_20189_(), projectile.m_20185_() - samuraiEntity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = samuraiEntity.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((projectile.m_20189_() - samuraiEntity.m_20189_()) * (projectile.m_20189_() - samuraiEntity.m_20189_()) + (projectile.m_20185_() - samuraiEntity.m_20185_()) * (projectile.m_20185_() - samuraiEntity.m_20185_()));
            Vec3 velocity = projectile.m_20184_();
            float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f)) continue;
            boolean a = true;
            if (projectile.m_37282_() == samuraiEntity || projectile.m_37282_() != null && samuraiEntity.m_7307_(projectile.m_37282_())) {
                a = false;
            }
            if (groundSpeed * 20.0f <= 0.15f) {
                a = false;
            }
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (arrow.f_36704_ > 0 && arrow.f_36703_) {
                    a = false;
                }
            }
            if ((newProjectile = (Projectile)projectile.m_6095_().m_20615_(samuraiEntity.f_19853_)) == null || !a) continue;
            projectile.m_5602_(null);
            newProjectile.m_20256_(CombatEvent.getOffsetPos((Entity)projectile, 0.0, 0.15, 2.5, samuraiEntity.f_20883_).m_82549_(projectile.m_20182_().m_82542_(-1.0, -1.0, -1.0)));
            newProjectile.m_20219_(projectile.m_20182_());
            if (newProjectile instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile newDamagingProjectile = (AbstractHurtingProjectile)newProjectile;
                Vec3 newPower = newProjectile.m_20184_();
                newDamagingProjectile.f_36813_ = newPower.m_7096_();
                newDamagingProjectile.f_36814_ = newPower.m_7098_();
                newDamagingProjectile.f_36815_ = newPower.m_7094_();
            }
            newProjectile.m_5602_((Entity)samuraiEntity);
            if (newProjectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)newProjectile;
                projectile.m_146870_();
                arrow.m_36781_(arrow.m_36789_() + 3.0);
                arrow.m_36762_(true);
                arrow.m_20254_(EnchantmentHelper.m_44914_((LivingEntity)samuraiEntity) != 0 ? 1200 : 0);
            }
            if (projectile instanceof AbstractHurtingProjectile || projectile instanceof AbstractArrow) {
                projectile.m_146870_();
                samuraiEntity.f_19853_.m_7967_((Entity)newProjectile);
                samuraiEntity.reboundedProjectiles.add(newProjectile);
            } else {
                projectile.m_146870_();
            }
            b = true;
        }
        if (b) {
            samuraiEntity.m_5496_(SoundEvents.f_12600_, 1.0f, 1.5f);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22282_, (double)0.85f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 1.5);
    }

    public int m_6062_() {
        return 500;
    }

    @Nonnull
    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource p_184601_1_) {
        return SoundEvents.f_12579_;
    }

    protected void m_7355_(@Nonnull BlockPos p_180429_1_, @Nonnull BlockState p_180429_2_) {
        if (this.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(ModItems.SAMURAI_HELMET.get()) && this.m_6844_(EquipmentSlot.CHEST).m_41720_().equals(ModItems.SAMURAI_CHESTPLATE.get()) && this.m_6844_(EquipmentSlot.LEGS).m_41720_().equals(ModItems.SAMURAI_LEGGINGS.get()) && this.m_6844_(EquipmentSlot.FEET).m_41720_().equals(ModItems.SAMURAI_BOOTS.get())) {
            this.m_5496_(SoundEvents.f_11676_, 0.75f, 1.0f);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "move", 2.0f, this::moving));
        data.addAnimationController(new AnimationController((IAnimatable)this, "rot", 0.0f, this::rot));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        NewSamuraiEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.parryTimes % 4 == 1 ? "parry" : (this.parryTimes % 4 == 2 ? "parry1" : (this.parryTimes % 4 == 3 ? "parry2" : "parry3")), Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_PULLING_OUT_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("pull_out_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_WITHDRAW_WEAPON)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("withdraw_weapon", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(IS_JUMP_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_MELEE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 0 ? "attacks" : ((Integer)this.f_19804_.m_135370_(MELEE_TYPE) == 1 ? "attacks2" : "attacks3"), Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("roll2", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dodge", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("roll", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("block", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DESTROY_PROJECTILES)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) == 0 || (Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) == 4 ? "destroy_projectile" : ((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) == 1 ? "melee_attack_type_2" : ((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) == 2 ? "melee_attack_type_3" : ((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) == 3 ? "melee_attack_type_4" : "destroy_projectile"))), Boolean.valueOf(true)));
        } else if (this.m_37888_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("celebrate", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "idle_pulled_out_weapon" : "idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState moving(AnimationEvent<P> event) {
        boolean shouldPlayWalkAnimation;
        event.getController().animationSpeed = 1.0;
        NewSamuraiEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        boolean bl = shouldPlayWalkAnimation = (Boolean)this.f_19804_.m_135370_(IS_DODGE) == false && (Boolean)this.f_19804_.m_135370_(IS_DASH) == false && (Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL) == false;
        if (((Boolean)this.f_19804_.m_135370_(IS_JUMP_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump_end", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_JUMP)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("jump", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (!(event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || !shouldPlayWalkAnimation)) {
            event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15));
            event.getController().setAnimation(new AnimationBuilder().addAnimation((Boolean)this.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false ? "walk_pulled_out_weapon" : "walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("null", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <P extends IAnimatable> PlayState rot(AnimationEvent<P> event) {
        event.getController().animationSpeed = 1.0;
        if (((Boolean)this.f_19804_.m_135370_(IS_DODGE_ROLL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_DASH)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("rot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("null", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_MELEE, (Object)false);
        this.f_19804_.m_135372_(CAN_DODGE_ROLL, (Object)false);
        this.f_19804_.m_135372_(CAN_JUMP_MELEE, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE, (Object)false);
        this.f_19804_.m_135372_(IS_MELEE_FAST, (Object)false);
        this.f_19804_.m_135372_(IS_DASH, (Object)false);
        this.f_19804_.m_135372_(IS_JUMP, (Object)false);
        this.f_19804_.m_135372_(IS_JUMP_ATTACK, (Object)false);
        this.f_19804_.m_135372_(IS_DODGE, (Object)false);
        this.f_19804_.m_135372_(IS_DODGE_ROLL, (Object)false);
        this.f_19804_.m_135372_(IS_PARRY, (Object)false);
        this.f_19804_.m_135372_(IS_RUN, (Object)false);
        this.f_19804_.m_135372_(IS_DESTROY_PROJECTILES, (Object)false);
        this.f_19804_.m_135372_(IS_PULLED_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_PULLING_OUT_WEAPON, (Object)false);
        this.f_19804_.m_135372_(IS_WITHDRAW_WEAPON, (Object)false);
        this.f_19804_.m_135372_(DASH_TICK, (Object)0);
        this.f_19804_.m_135372_(DODGE_TICK, (Object)0);
        this.f_19804_.m_135372_(PARRY_TICK, (Object)0);
        this.f_19804_.m_135372_(BLOCK_TICK, (Object)0);
        this.f_19804_.m_135372_(DASH_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(PARRY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DODGE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(MELEE_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(JUMP_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DESTROY_PROJECTILES_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(MELEE_TYPE, (Object)0);
        this.f_19804_.m_135372_(DESTROY_PROJECTILES_TYPE, (Object)0);
    }

    protected void CooldownReduction() {
        if ((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DASH_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DASH_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(PARRY_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(PARRY_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DODGE_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(MELEE_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(JUMP_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(JUMP_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(JUMP_COOLDOWN) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) > 0) {
            this.f_19804_.m_135381_(DESTROY_PROJECTILES_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) - 1));
        }
    }

    protected void TickReduction() {
        if (this.noDamagesTimer > 0) {
            --this.noDamagesTimer;
        }
        if ((Integer)this.f_19804_.m_135370_(DASH_TICK) > 0) {
            this.f_19804_.m_135381_(DASH_TICK, (Object)((Integer)this.f_19804_.m_135370_(DASH_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(PARRY_TICK) > 0) {
            this.f_19804_.m_135381_(PARRY_TICK, (Object)((Integer)this.f_19804_.m_135370_(PARRY_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(DODGE_TICK) > 0) {
            this.f_19804_.m_135381_(DODGE_TICK, (Object)((Integer)this.f_19804_.m_135370_(DODGE_TICK) - 1));
        }
        if ((Integer)this.f_19804_.m_135370_(BLOCK_TICK) > 0) {
            this.f_19804_.m_135381_(BLOCK_TICK, (Object)((Integer)this.f_19804_.m_135370_(BLOCK_TICK) - 1));
        }
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    public boolean m_37882_() {
        return super.m_37882_() && this.m_5647_() == null;
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final NewSamuraiEntity mob;
        protected int type;
        private int delayCounter;
        private int parry;
        protected static final int horizontalChop = 0;
        protected static final int chopFromBottomUp = 1;
        protected static final int obliqueChop = 2;
        protected boolean canMoving;
        protected boolean hasNext;

        public DoHurtTargetGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_MELEE) != false && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_8045_() {
            if (!this.hasNext) {
                return this.isAttacking() && this.mob.m_5448_() != null;
            }
            if (!this.isAttacking()) {
                this.mob.timer = 0;
                this.mob.noDamagesTimer = 2;
                this.type = this.type != 2 ? ++this.type : 1;
                return this.mob.m_217043_().m_188499_() && this.mob.m_5448_() != null && (this.mob.m_5448_().f_20916_ > 0 || this.mob.f_19796_.m_188501_() <= 0.35f || this.mob.m_5448_() instanceof SamuraiEntity || this.mob.m_5448_() instanceof NewSamuraiEntity) && (this.mob.m_20191_().m_82381_(this.mob.m_5448_().m_20191_().m_82400_(4.0 + 1.5 * (double)this.mob.m_217043_().m_188501_())) || this.mob.f_19796_.m_188501_() <= 0.15f) && this.mob.parryTimes == this.parry;
            }
            return true;
        }

        private boolean isAttacking() {
            return this.mob.timer < (this.type == 0 ? 7 : (this.type == 1 ? 12 : 10)) - this.mob.m_217043_().m_188503_(3) + (Math.max(4 - this.mob.aiStrength, 1) - 1);
        }

        public boolean m_6767_() {
            return this.mob.f_20916_ > 0 && this.mob.m_5448_() != null;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 0;
            this.parry = this.mob.parryTimes;
            this.canMoving = true;
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)true);
            this.mob.f_19804_.m_135381_(CAN_MELEE, (Object)false);
            this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)0);
        }

        public void m_8037_() {
            ++this.mob.timer;
            this.mob.f_19804_.m_135381_(PARRY_TICK, (Object)0);
            List effectsList = this.mob.f_19853_.m_6443_(AttackEffects.class, this.mob.m_20191_().m_82400_(2.0), pg -> (Integer)pg.m_20088_().m_135370_(AttackEffects.LIFE_TICKS) <= 5 && pg.getCaster() == this.mob && pg.getTy() == 1);
            if (!effectsList.isEmpty()) {
                for (AttackEffects sEffect : effectsList) {
                    sEffect.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 12.335, this.mob.f_20883_));
                    sEffect.m_146922_(-(sEffect.m_146908_() % 360.0f) - 90.0f);
                    sEffect.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                }
            }
            if (this.type == 0) {
                this.attack(3);
                this.hasNext = true;
            } else if (this.type == 1) {
                this.attack(8);
                this.hasNext = true;
            } else if (this.type == 2) {
                this.attack(4);
                this.hasNext = true;
            }
            if (this.mob.m_5448_() == null) {
                this.hasNext = false;
            }
            if (!this.canMoving) {
                this.mob.m_21573_().m_26573_();
                if (--this.delayCounter <= 0) {
                    this.canMoving = true;
                    this.delayCounter = 4 + this.mob.m_217043_().m_188503_(5);
                    if (this.mob.m_5448_() != null) {
                        this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 1.525 + (double)this.mob.aiStrength * 0.075);
                    }
                }
            }
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
                if (((double)this.mob.m_5448_().m_20270_((Entity)this.mob) > 1.5 || this.mob.aiStrength >= 2) && --this.delayCounter <= 0) {
                    this.delayCounter = Math.max(0, 2 + this.mob.f_19796_.m_188503_(6) - this.mob.aiStrength * 3);
                    this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 1.475 + (double)this.mob.aiStrength * 0.085);
                }
            }
            this.mob.f_19804_.m_135381_(MELEE_TYPE, (Object)this.type);
        }

        private void attack(int i) {
            if (this.mob.timer == 1 + (this.type == 1 ? 4 : (this.type == 2 ? 2 : 0))) {
                this.canMoving = true;
                float rot = this.type == 0 ? 15.0f : (this.type == 1 ? -195.0f : 15.0f);
                AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.0f);
                e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                e.setCaster((LivingEntity)this.mob);
                e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
                e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
                this.mob.f_19853_.m_7967_((Entity)e);
                if (!this.mob.m_20096_() && this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_()) {
                    this.mob.m_20334_(0.0, 0.25, 0.0);
                }
            }
            if (this.mob.timer == i) {
                this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
                CombatEvent.AreaAttack((LivingEntity)this.mob, 4.85f, 5.0f, 1.5f, 5.0f, 170.0f, 1.2147f, 0.15, 0.0, false);
                NewSamuraiEntity.DestroyProjectiles(this.mob, 5.0f, 1.8f, 5.0f, 5.0f, 170.0f);
                this.canMoving = false;
                this.delayCounter = 1 + this.mob.m_217043_().m_188503_(3);
                if (!this.mob.m_20096_() && this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7918_(0, -1, 0)).m_60795_()) {
                    this.mob.m_20334_(0.0, 0.425, 0.0);
                }
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_MELEE, (Object)false);
            this.mob.f_19804_.m_135381_(CAN_DODGE_ROLL, (Object)((Integer)this.mob.f_19804_.m_135370_(DODGE_COOLDOWN) > 0 ? 1 : 0));
            this.mob.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)25);
        }
    }

    static class JumpDoHurtTargetGoal
    extends Goal {
        protected final NewSamuraiEntity mob;
        protected int type;
        protected static final int horizontalChop = 0;
        protected boolean canMoving;
        protected Entity sEffect;

        public JumpDoHurtTargetGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_JUMP_MELEE) != false && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 8;
        }

        public boolean m_6767_() {
            return false;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.type = 0;
            this.canMoving = true;
            this.mob.f_19804_.m_135381_(IS_JUMP_ATTACK, (Object)true);
            this.mob.f_19804_.m_135381_(CAN_JUMP_MELEE, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            this.attack();
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
                this.sEffect.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 12.335, this.mob.f_20883_));
                this.sEffect.m_146922_(-(this.sEffect.m_146908_() % 360.0f) - 90.0f);
                this.sEffect.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
            }
        }

        private void attack() {
            if (this.mob.timer == 1 + (this.type == 1 ? 4 : (this.type == 2 ? 2 : 0))) {
                float rot = 90.0f;
                AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.0f);
                e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
                e.setCaster((LivingEntity)this.mob);
                e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
                e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
                this.mob.f_19853_.m_7967_((Entity)e);
                this.sEffect = e;
            }
            if (this.mob.timer == 5) {
                this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
                JumpDoHurtTargetGoal.AreaAttack((LivingEntity)this.mob, 4.5f, 5.0f, 2.2f, 5.0f, 170.0f, 1.26667f, 0.35, 0.0, false);
                NewSamuraiEntity.DestroyProjectiles(this.mob, 5.0f, 3.0f, 5.0f, 5.0f, 225.0f);
                this.canMoving = false;
                if (this.mob.m_5448_() != null) {
                    Vec3 m = this.mob.m_20184_().m_82520_(Math.max(Math.min(this.mob.m_5448_().m_20185_() - this.mob.m_20185_(), 1.3), -1.3), 0.0, Math.max(Math.min(this.mob.m_5448_().m_20189_() - this.mob.m_20189_(), 1.3), -1.3)).m_82490_(0.375);
                    this.mob.m_20334_(m.f_82479_, 0.433333, m.f_82481_);
                }
            }
        }

        public static void AreaAttack(LivingEntity v, float range, float X, float Y, float Z, float arc, float damage, double DeltaY, double knockback_reduction, boolean throughArmor) {
            for (LivingEntity entityHit : v.f_19853_.m_45976_(LivingEntity.class, v.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
                Mob mob;
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - v.m_20189_(), entityHit.m_20185_() - v.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = v.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - v.m_20189_()) * (entityHit.m_20189_() - v.m_20189_()) + (entityHit.m_20185_() - v.m_20185_()) * (entityHit.m_20185_() - v.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || v.m_7307_((Entity)entityHit) || entityHit == v || !(v instanceof Mob) || !(mob = (Mob)v).m_21574_().m_148306_((Entity)entityHit)) continue;
                entityHit.f_19802_ = 0;
                if (throughArmor && !entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), (float)v.m_21133_(Attributes.f_22281_) * damage)) {
                    Player player;
                    entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v).m_19380_(), (float)v.m_21133_(Attributes.f_22281_) * damage * 0.2f);
                    if (entityHit instanceof Player && (player = (Player)entityHit).m_21254_()) {
                        player.m_36384_(true);
                    }
                } else {
                    entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), (float)v.m_21133_(Attributes.f_22281_) * damage);
                }
                v.m_21335_((Entity)entityHit);
                entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)v), damage);
                float attackKnockback = (float)mob.m_21133_(Attributes.f_22282_) + 2.0f;
                double ratioX = Mth.m_14031_((float)(mob.m_146908_() * ((float)Math.PI / 180)));
                double ratioZ = -Mth.m_14089_((float)(mob.m_146908_() * ((float)Math.PI / 180)));
                CombatEvent.forceKnockback(entityHit, attackKnockback * 0.8f, ratioX, ratioZ, 0.0);
                entityHit.m_20256_(entityHit.m_20184_().m_82520_(0.0, DeltaY, 0.0));
            }
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_JUMP_ATTACK, (Object)false);
            this.mob.f_19804_.m_135381_(JUMP_COOLDOWN, (Object)50);
            this.mob.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)8);
        }
    }

    static class DestroyProjectileGoal
    extends Goal {
        private static final int attackTimerTakesEffect = 1;
        private static final int attackTimerEnd = 2;
        private final NewSamuraiEntity mob;
        private int timer;

        public DestroyProjectileGoal(NewSamuraiEntity entity) {
            this.mob = entity;
        }

        public boolean m_8036_() {
            boolean b = false;
            for (Projectile entityHit : this.mob.f_19853_.m_45976_(Projectile.class, this.mob.m_20191_().m_82377_(18.0, 0.5, 18.0))) {
                boolean a;
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.mob.m_20189_(), entityHit.m_20185_() - this.mob.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.mob.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                Vec3 velocity = entityHit.m_20184_();
                float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.mob.m_20189_()) * (entityHit.m_20189_() - this.mob.m_20189_()) + (entityHit.m_20185_() - this.mob.m_20185_()) * (entityHit.m_20185_() - this.mob.m_20185_()));
                if (!(entityHitDistance <= 6.25f && entityRelativeAngle <= 112.5f && entityRelativeAngle >= -112.5f || entityRelativeAngle >= 247.5f) && !(entityRelativeAngle <= -247.5f) || entityHit.m_37282_() == this.mob || entityHit.m_37282_() != null && (entityHit.m_37282_().m_7307_((Entity)this.mob) || this.mob.m_7307_(entityHit.m_37282_())) && entityHit.m_37282_() != this.mob.m_5448_() || !(a = !(groundSpeed * 20.0f <= 0.15f))) continue;
                if (entityHit instanceof AbstractArrow) {
                    AbstractArrow arrow = (AbstractArrow)entityHit;
                    if (arrow.f_36704_ > 0 && arrow.f_36703_) continue;
                    b = true;
                    break;
                }
                if (entityHit instanceof AbstractHurtingProjectile) {
                    b = true;
                    break;
                }
                b = true;
                break;
            }
            return b && (Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_DASH) == false && (Boolean)this.mob.f_19804_.m_135370_(IS_DODGE) == false && (Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_COOLDOWN) <= 0 && this.mob.aiStrength > 2;
        }

        public boolean m_8045_() {
            return this.timer < 2;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            this.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DESTROY_PROJECTILES, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
            int type = (Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE);
            float rot = type == 0 ? -195.0f : (type == 1 ? -90.0f : (type == 2 ? 45.0f : (type == 3 ? 90.0f : -195.0f)));
            AttackEffects e = AttackEffects.spawnAttackEffects((EntityType)ModEntityTypes.ATTACK_EFFECTS.get(), this.mob.f_19853_, 1, rot, 1.1f, 2.0f);
            e.m_20219_(CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.335, this.mob.f_20883_));
            e.setCaster((LivingEntity)this.mob);
            e.m_7618_(EntityAnchorArgument.Anchor.EYES, CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 5.335, this.mob.f_20883_));
            e.m_146922_(-(e.m_146908_() % 360.0f) - 90.0f);
            this.mob.f_19853_.m_7967_((Entity)e);
        }

        public void m_8037_() {
            ++this.timer;
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.timer == 2) {
                this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.2f);
            }
            NewSamuraiEntity.DestroyProjectiles(this.mob, 7.5f, 7.0f, 0.75f, 7.0f, 265.0f);
        }

        public void m_8041_() {
            this.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DESTROY_PROJECTILES, (Object)false);
            this.mob.f_19804_.m_135381_(DESTROY_PROJECTILES_COOLDOWN, (Object)((Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) >= 4 ? 3 : 1));
            this.mob.f_19804_.m_135381_(DESTROY_PROJECTILES_TYPE, (Object)((Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) + 1));
            this.mob.f_19804_.m_135381_(DESTROY_PROJECTILES_TYPE, (Object)((Integer)this.mob.f_19804_.m_135370_(DESTROY_PROJECTILES_TYPE) % 4));
        }
    }

    static class PullOutWeaponGoal
    extends Goal {
        private final NewSamuraiEntity mob;

        public PullOutWeaponGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) == false && ((double)this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 8.15 + (double)this.mob.aiStrength || this.mob.aiStrength >= 2 && this.mob.m_217043_().m_188503_(8) == 0);
        }

        public boolean m_6767_() {
            return this.mob.timer >= 10;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)true);
            this.mob.f_19804_.m_135381_(IS_PULLING_OUT_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class JumpGoal
    extends Goal {
        private final NewSamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 6;

        public JumpGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.aiStrength >= 2 && this.mob.m_20227_(2.0) <= this.mob.m_5448_().m_20186_() && (Integer)this.mob.f_19804_.m_135370_(JUMP_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return (this.mob.timer < 8 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_()) && (Boolean)this.mob.f_19804_.m_135370_(CAN_JUMP_MELEE) == false;
        }

        public void m_8056_() {
            this.mob.f_19804_.m_135381_(IS_JUMP, (Object)true);
            this.mob.timer = 0;
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_JUMP, (Object)false);
            this.mob.f_19804_.m_135381_(JUMP_COOLDOWN, (Object)50);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
                if (this.mob.m_20191_().m_82381_(this.mob.m_5448_().m_20191_().m_82400_(3.0))) {
                    this.mob.f_19804_.m_135381_(CAN_JUMP_MELEE, (Object)true);
                }
            }
            if (this.mob.timer == 4 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_()) && this.mob.m_5448_() != null) {
                Vec3 m = this.mob.m_20184_().m_82520_(Math.max(Math.min(this.mob.m_5448_().m_20185_() - this.mob.m_20185_(), 1.3), -1.3), 0.0, Math.max(Math.min(this.mob.m_5448_().m_20189_() - this.mob.m_20189_(), 1.3), -1.3)).m_82490_(1.15);
                this.mob.m_20334_(m.f_82479_, Math.sqrt(Math.max(Math.min(this.mob.m_5448_().m_20186_() - this.mob.m_20186_(), 11.8), 0.738)) * 0.5, m.f_82481_);
            }
            if (this.mob.m_6084_() && this.mob.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.mob.f_19853_, (Entity)this.mob)) {
                AABB axisalignedbb = this.mob.m_20191_().m_82377_(0.35, 0.6, 0.35);
                for (BlockPos blockpos : BlockPos.m_121921_((AABB)axisalignedbb).toList()) {
                    BlockState blockState = this.mob.f_19853_.m_8055_(blockpos);
                    if (!((double)blockpos.m_123342_() > this.mob.m_20227_(0.6)) || blockState.m_60795_()) continue;
                    this.mob.f_19853_.m_46953_(blockpos, true, (Entity)this.mob);
                }
            }
        }
    }

    static class WithdrawWeaponGoal
    extends Goal {
        private final NewSamuraiEntity mob;

        public WithdrawWeaponGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (this.mob.m_5448_() == null || !this.mob.m_5448_().m_6084_()) && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && this.mob.MemoryTimeAfterTargetDisappears <= this.mob.f_19797_;
        }

        public boolean m_8045_() {
            return this.mob.timer < 20;
        }

        public void m_8056_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)true);
        }

        public void m_8041_() {
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_PULLED_OUT_WEAPON, (Object)false);
            this.mob.f_19804_.m_135381_(IS_WITHDRAW_WEAPON, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
        }
    }

    static class DodgeGoal
    extends Goal {
        private final NewSamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 6;
        private float dodgeYaw;

        public DodgeGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return ((this.mob.m_20069_() || this.mob.m_20077_()) && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 12.0f || (Integer)this.mob.f_19804_.m_135370_(MELEE_COOLDOWN) > 0 && this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.0f || this.mob.m_5448_() != null && this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 13.0f && this.mob.f_20916_ > 0) && (Integer)this.mob.f_19804_.m_135370_(DODGE_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 8 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            if (!modifiableattributeinstance.m_22109_(MODIFIER)) {
                modifiableattributeinstance.m_22118_(MODIFIER);
            }
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)true);
        }

        public void m_8041_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            modifiableattributeinstance.m_22130_(MODIFIER);
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE, (Object)false);
            this.mob.f_19804_.m_135381_(DODGE_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)35);
            this.mob.f_19804_.m_135381_(DODGE_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            if (!this.mob.m_20096_()) {
                this.mob.reboundedProjectiles.addAll(this.mob.f_19853_.m_45976_(Projectile.class, this.mob.m_20191_().m_82400_(4.5)));
            }
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 1) {
                this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 150.0f - 75.0f);
            }
            if (this.mob.timer == 6 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_())) {
                float speed = -2.25f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.6, m.f_82481_);
            }
        }
    }

    static class DodgeRollGoal
    extends Goal {
        private final NewSamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 9;
        private float dodgeYaw;

        public DodgeRollGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return (Boolean)this.mob.f_19804_.m_135370_(CAN_DODGE_ROLL) != false && this.mob.aiStrength > 1 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 9 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            if (!modifiableattributeinstance.m_22109_(MODIFIER)) {
                modifiableattributeinstance.m_22118_(MODIFIER);
            }
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE_ROLL, (Object)true);
        }

        public void m_8041_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            modifiableattributeinstance.m_22130_(MODIFIER);
            this.mob.timer = 0;
            this.mob.f_19804_.m_135381_(IS_DODGE_ROLL, (Object)false);
            this.mob.f_19804_.m_135381_(CAN_DODGE_ROLL, (Object)false);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            this.mob.reboundedProjectiles.addAll(this.mob.f_19853_.m_45976_(Projectile.class, this.mob.m_20191_().m_82400_(3.0)));
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 1) {
                this.dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 60.0f - 30.0f);
            }
            if (this.mob.timer == 6) {
                float speed = -2.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(this.dodgeYaw), 0.0, (double)speed * Math.sin(this.dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }

    static class DashGoal
    extends Goal {
        private final NewSamuraiEntity mob;
        private static final int dodgeTimerTakesEffect = 6;

        public DashGoal(NewSamuraiEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.aiStrength > 2 && (this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 12.0f || this.mob.m_20077_() || this.mob.m_20069_()) && (Integer)this.mob.f_19804_.m_135370_(DASH_COOLDOWN) <= 0 && (Boolean)this.mob.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON) != false;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8045_() {
            return this.mob.timer < 8 || !this.mob.m_20096_() && !this.mob.m_20077_() && !this.mob.m_20069_();
        }

        public void m_8056_() {
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            if (!modifiableattributeinstance.m_22109_(MODIFIER)) {
                modifiableattributeinstance.m_22118_(MODIFIER);
            }
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)true);
            this.mob.timer = 0;
        }

        public void m_8041_() {
            this.mob.timer = 0;
            AttributeInstance modifiableattributeinstance = this.mob.m_21051_(Attributes.f_22278_);
            modifiableattributeinstance.m_22130_(MODIFIER);
            this.mob.f_19804_.m_135381_(IS_DASH, (Object)false);
            this.mob.f_19804_.m_135381_(DASH_COOLDOWN, (Object)30);
            this.mob.f_19804_.m_135381_(MELEE_COOLDOWN, (Object)0);
            this.mob.f_19804_.m_135381_(DASH_TICK, (Object)8);
        }

        public void m_8037_() {
            this.mob.m_21573_().m_26573_();
            ++this.mob.timer;
            this.mob.reboundedProjectiles.addAll(this.mob.f_19853_.m_45976_(Projectile.class, this.mob.m_20191_().m_82400_(3.5)));
            if (this.mob.m_5448_() != null) {
                this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            }
            if (this.mob.timer == 4 && (this.mob.m_20096_() || this.mob.m_20077_() || this.mob.m_20069_()) && this.mob.m_5448_() != null) {
                float dodgeYaw = (float)Math.toRadians(this.mob.f_20883_ % 360.0f + 90.0f + this.mob.m_217043_().m_188501_() * 20.0f - 10.0f);
                float speed = 2.5f;
                Vec3 m = this.mob.m_20184_().m_82520_((double)speed * Math.cos(dodgeYaw), 0.0, (double)speed * Math.sin(dodgeYaw));
                this.mob.m_20334_(m.f_82479_, 0.1, m.f_82481_);
            }
        }
    }

    class SamuraiAvoidEntityGoal
    extends AvoidAndApproachTargetGoal<LivingEntity> {
        public SamuraiAvoidEntityGoal(PathfinderMob enchanterIn, Class entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, boolean followingTargetEvenIfNotSeen) {
            super(enchanterIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn, followingTargetEvenIfNotSeen);
        }

        public boolean m_6767_() {
            return true;
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && (Integer)NewSamuraiEntity.this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && (Integer)NewSamuraiEntity.this.f_19804_.m_135370_(MELEE_COOLDOWN) > 0;
        }
    }

    static class SamuraiAttackGoal
    extends MeleeAttackGoal {
        protected final NewSamuraiEntity mobEntity;
        private int delayCounter;

        public SamuraiAttackGoal(NewSamuraiEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            super((PathfinderMob)p_i1636_1_, p_i1636_2_, p_i1636_4_);
            this.mobEntity = p_i1636_1_;
        }

        public void m_8056_() {
            super.m_8056_();
            this.delayCounter = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.delayCounter = 0;
        }

        public void m_8037_() {
            if (this.mobEntity.m_5448_() == null) {
                return;
            }
            if (((Boolean)this.mobEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue()) {
                super.m_8037_();
            } else {
                this.mobEntity.f_21365_.m_24960_((Entity)this.mobEntity.m_5448_(), 30.0f, 30.0f);
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.mobEntity.m_217043_().m_188503_(5);
                    this.mobEntity.m_21573_().m_5624_((Entity)this.mobEntity.m_5448_(), 1.2);
                }
                this.m_6739_(this.mobEntity.m_5448_(), this.mobEntity.m_20275_(this.mobEntity.m_5448_().m_20185_(), this.mobEntity.m_5448_().m_20191_().f_82289_, this.mobEntity.m_5448_().m_20189_()));
            }
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (this.mobEntity.m_20191_().m_82381_(enemy.m_20191_().m_82400_(3.0 + 2.1 * (double)this.f_25540_.m_217043_().m_188501_())) && ((Boolean)this.mobEntity.f_19804_.m_135370_(IS_PULLED_OUT_WEAPON)).booleanValue() && this.mobEntity.m_217043_().m_188503_(Math.max((4 - this.mobEntity.aiStrength) * (4 - this.mobEntity.aiStrength), 1)) <= 3) {
                this.mobEntity.f_19804_.m_135381_(CAN_MELEE, (Object)true);
            }
        }
    }
}

